---
issue_id: "BUG-TCY-0001-TC-003"
test_case_id: "TC-003"
run_id: "TCY-0001-TC-003-TR-001"
titleName: "Login fails with timeout error even when valid credentials are used"
endpoint: "Login page"
created_by: "your-email@example.com"
created_at: "2025-10-30"
test_type: "Manual"
priority: "High"
severity: "Low"
assigned: "Mahesh"
status: "REJECTED"
---

### Description

During login attempts with valid credentials, the system fails to authenticate the user due to a network timeout. The application displays a generic failure message instead of handling the timeout gracefully or retrying the request.

### Pre-requisites:

1. Access to the application’s login page — [https://owasp.glueup.com/](https://owasp.glueup.com/)
2. Valid user credentials for testing (username and password).
3. Simulated or unstable network connection to induce timeout behavior.

### Test Steps

Step 1: Launch the application and navigate to the login page.  
Step 2: Enter valid credentials and attempt to log in.  
Step 3: Simulate network delay or partial disconnection to cause timeout.  
Step 4: Observe the system’s response.

### Expected Result

1. The system should either retry the request or display a clear “Network Timeout” message.  
2. The user should not be shown incorrect “Invalid credentials” error messages.  
3. Application should handle network timeouts gracefully without affecting session state.

### Actual Result

1. Login attempt fails with a timeout error.  
2. System displays a generic “Login failed” or “Invalid credentials” message.  
3. User is unable to log in despite using correct credentials.

### Attachment

- screenshot: [screenshot](/OWASP_Glueup/user-acceptance-testing/images/loginButtonClick.png)


